import sys

def solve():
    input_data = sys.stdin.read().split()
    if not input_data:
        return
    
    n = int(input_data[0])
    points = []
    idx = 1
    for _ in range(n):
        x = int(input_data[idx])
        y = int(input_data[idx+1])
        points.append((x, y))
        idx += 2

    ans = 6 * n

    # Grupisanje za t > 0
    horiz_groups = {}  # (y, x % 2)
    vert_groups = {}   # (x, y % 2)
    diag1_groups = {}  # x + y
    diag2_groups = {}  # y - x

    for x, y in points:
        k1 = (y, x % 2)
        horiz_groups[k1] = horiz_groups.get(k1, 0) + 1
        
        k2 = (x, y % 2)
        vert_groups[k2] = vert_groups.get(k2, 0) + 1
        
        k3 = x + y
        diag1_groups[k3] = diag1_groups.get(k3, 0) + 1
        
        k4 = y - x
        diag2_groups[k4] = diag2_groups.get(k4, 0) + 1

    for count in horiz_groups.values():
        ans += count * (count - 1) // 2
        
    for count in vert_groups.values():
        ans += count * (count - 1) // 2
        
    for count in diag1_groups.values():
        ans += 2 * (count * (count - 1) // 2)
        
    for count in diag2_groups.values():
        ans += 2 * (count * (count - 1) // 2)

    print(ans)